/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.screens.mainMenu;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.InputHelper;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.screens.mainMenu.MainMenuScreen;
import com.megacrit.cardcrawl.screens.mainMenu.MenuCancelButton;

public class TrialScreen {
    private static final float START_X = 600.0f * Settings.scale;
    private static final float START_Y = (float)Settings.HEIGHT - 300.0f * Settings.scale;
    private float scrollY;
    private float targetY;
    public MenuCancelButton button;

    public TrialScreen() {
        this.targetY = this.scrollY = START_Y;
        this.button = new MenuCancelButton();
    }

    public void open() {
        this.button.show("Return");
        this.targetY = (float)Settings.HEIGHT - 100.0f * Settings.scale;
        this.scrollY = (float)Settings.HEIGHT - 400.0f * Settings.scale;
    }

    public void update() {
        this.button.update();
        if (this.button.hb.clicked) {
            CardCrawlGame.mainMenuScreen.screen = MainMenuScreen.CurScreen.MAIN_MENU;
            this.button.hide();
        }
        if (InputHelper.scrolledUp) {
            this.targetY -= Settings.MAP_SCROLL_SPEED;
        } else if (InputHelper.scrolledDown) {
            this.targetY += Settings.MAP_SCROLL_SPEED;
        }
        this.scrollY = MathHelper.scrollSnapLerpSpeed(this.scrollY, this.targetY);
    }

    public void render(SpriteBatch sb) {
        sb.setColor(new Color(0.0f, 0.0f, 0.0f, 0.75f));
        sb.draw(ImageMaster.WHITE_SQUARE_IMG, 0.0f, 0.0f, (float)Settings.WIDTH, (float)Settings.HEIGHT);
        FontHelper.renderSmartText(sb, FontHelper.cardDescFont_N, "This feature is not yet implemented", START_X - 50.0f * Settings.scale, this.scrollY - 0.0f * Settings.scale, 99999.0f, 0.0f, Settings.CREAM_COLOR);
        this.button.render(sb);
    }
}

